/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.ubesdelight.common.block.leaf_feast.base.forge;

import com.chefmooon.ubesdelight.common.block.entity.forge.UniversalLeafFeastBlockEntityImpl;
import com.chefmooon.ubesdelight.common.block.leaf_feast.base.LeafFeastBlock;
import com.chefmooon.ubesdelight.common.block.leaf_feast.base.UniversalLeafFeastBlock;
import com.chefmooon.ubesdelight.common.core.LeafFeastTypes;
import com.chefmooon.ubesdelight.common.registry.UbesDelightBlocks;
import com.chefmooon.ubesdelight.common.utility.BuiltInRegistryUtil;
import com.chefmooon.ubesdelight.common.utility.ItemStackUtil;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class UniversalLeafFeastBlockImpl
extends UniversalLeafFeastBlock {
    public UniversalLeafFeastBlockImpl(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult result = InteractionResult.FAIL;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof UniversalLeafFeastBlockEntityImpl)) {
            return result;
        }
        UniversalLeafFeastBlockEntityImpl universalLeafFeastBlockEntity = (UniversalLeafFeastBlockEntityImpl)blockEntity;
        ItemStack heldStack = player.m_21120_(hand);
        ItemStack offHandStack = player.m_21206_();
        if (heldStack.m_41619_()) {
            return this.tryRemoveItemFromPlayerHand(state, level, pos, universalLeafFeastBlockEntity, heldStack, offHandStack, player, hand);
        }
        return this.tryAddItemFromPlayerHand(state, level, pos, universalLeafFeastBlockEntity, heldStack, offHandStack, player, hand);
    }

    private InteractionResult tryAddItemFromPlayerHand(BlockState state, Level level, BlockPos pos, UniversalLeafFeastBlockEntityImpl universalLeafFeastBlockEntity, ItemStack heldStack, ItemStack offHandStack, Player player, InteractionHand hand) {
        InteractionResult result = InteractionResult.PASS;
        int servings = (Integer)state.m_61143_((Property)SERVINGS);
        if (heldStack.m_41619_()) {
            return result;
        }
        if (heldStack.m_41614_()) {
            if ((state.m_61143_((Property)LEAF_FEAST_TYPE) == LeafFeastTypes.END || state.m_61143_((Property)LEAF_FEAST_TYPE) == LeafFeastTypes.TIP) && servings >= 3) {
                return InteractionResult.FAIL;
            }
            if (universalLeafFeastBlockEntity.addItem(player, player.m_150110_().f_35937_ ? heldStack.m_41777_() : heldStack)) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)SERVINGS, (Comparable)Integer.valueOf(servings + 1)), 3);
                this.playAddSound(level, universalLeafFeastBlockEntity.m_58899_());
                LeafFeastBlock.triggerInsertAdvancement(player);
                return InteractionResult.SUCCESS;
            }
        }
        return result;
    }

    private InteractionResult tryRemoveItemFromPlayerHand(BlockState state, Level level, BlockPos pos, UniversalLeafFeastBlockEntityImpl universalLeafFeastBlockEntity, ItemStack heldStack, ItemStack offHandStack, Player player, InteractionHand hand) {
        int servings = (Integer)state.m_61143_((Property)SERVINGS);
        if (servings > 1 && !level.m_7731_(pos, (BlockState)state.m_61124_((Property)SERVINGS, (Comparable)Integer.valueOf(servings - 1)), 3)) {
            return InteractionResult.PASS;
        }
        this.playRemoveSound(level, universalLeafFeastBlockEntity.m_58899_());
        ItemStack itemStack = universalLeafFeastBlockEntity.removeItem();
        if (!player.m_7500_()) {
            if (player.m_6144_() && (player.m_36324_().m_38721_() || Objects.requireNonNull(itemStack.m_41720_().getFoodProperties(itemStack, (LivingEntity)player)).m_38747_())) {
                UniversalLeafFeastBlockImpl.tryEat(itemStack, level, pos, player);
            } else if (!player.m_150109_().m_36054_(itemStack)) {
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)itemStack);
            }
        }
        if (servings == 1 && !level.m_7731_(pos, this.getTransformState(BuiltInRegistryUtil.getBlock(UbesDelightBlocks.LEAF_FEAST), state), 3)) {
            return InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    public static void tryEat(ItemStack itemStack, Level level, BlockPos pos, Player player) {
        ItemStack container = ItemStackUtil.getContainer(itemStack);
        if (!container.m_41619_()) {
            UniversalLeafFeastBlockImpl.spawnContainer(level, pos, player.m_6350_().m_122424_(), container);
        }
        player.m_5584_(level, itemStack);
        LeafFeastBlock.triggerConsumeAdvancement(player);
    }

    public static void spawnContainer(Level level, BlockPos blockPos, Direction direction, ItemStack itemStack) {
        ItemEntity entity = new ItemEntity(level, (double)blockPos.m_123341_() + 0.5 + (double)direction.m_122429_() * 0.2, (double)blockPos.m_123342_() + 0.2, (double)blockPos.m_123343_() + 0.5 + (double)direction.m_122431_() * 0.2, itemStack.m_41777_());
        entity.m_20334_((double)((float)direction.m_122429_() * 0.2f), 0.0, (double)((float)direction.m_122431_() * 0.2f));
        level.m_7967_((Entity)entity);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() == newState.m_60734_()) {
            return;
        }
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity instanceof UniversalLeafFeastBlockEntityImpl) {
            UniversalLeafFeastBlockEntityImpl universalLeafFeastBlockEntity = (UniversalLeafFeastBlockEntityImpl)tileEntity;
            Containers.m_19010_((Level)level, (BlockPos)pos, universalLeafFeastBlockEntity.getItems());
            level.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof UniversalLeafFeastBlockEntityImpl) {
            UniversalLeafFeastBlockEntityImpl universalLeafFeastBlockEntity = (UniversalLeafFeastBlockEntityImpl)blockEntity;
            return universalLeafFeastBlockEntity.getItemsQuantity() * 2;
        }
        return 0;
    }
}

